--[[ja]]
--[[
̃XN[tB^[́uDefault Extended A.C(waiei)v
XN[tB^[̃\[XQlɂ܂B
]]


local t;

local filter1;
local filter2;
if ReadPrefFromFile("ScreenFilterP1") ~= nil then
	filter1 = GetUserPref("ScreenFilterP1");
else
	filter1 = 'OFF';
end;
if ReadPrefFromFile("ScreenFilterP2") ~= nil then
	filter2 = GetUserPref("ScreenFilterP2");
else
	filter2 = 'OFF';
end;

local function GetFilterPosX(pn)
	local r=SCREEN_CENTER_X;
	local p;
	local st=GAMESTATE:GetCurrentStyle():GetStyleType();
	if GAMESTATE:GetNumPlayersEnabled()==1 and Center1Player() then
		r=SCREEN_CENTER_X;
	else
		if pn==PLAYER_1 then
			p="1";
		else
			p="2";
		end;
		r=THEME:GetMetric("ScreenGameplay","PlayerP"..p..ToEnumShortString(st).."X");
	end;
	return r;
end;
local function GetFilterSizeX(pn)
	local r=0;
	local one=THEME:GetMetric("ArrowEffects","ArrowSpacing");
	local stt=GAMESTATE:GetCurrentSteps(pn):GetStepsType();
	if stt=='StepsType_Dance_Single' then
		r=one*4;
	elseif stt=='StepsType_Dance_Double' then
		r=one*8;
	elseif stt=='StepsType_Dance_Couple' then
		r=one*4;
	elseif stt=='StepsType_Dance_Solo' then
		r=one*6;
	elseif stt=='StepsType_Dance_Threepanel' then
		r=one*3;
	else
		r=SCREEN_WIDTH;
	end;
	return r;
end;

t=Def.ActorFrame{
	Def.Quad{
		Name="FilterP1";
		InitCommand=cmd(y,SCREEN_CENTER_Y;diffuse,Color("Black"););
		OnCommand=function(self)
			self:x(GetFilterPosX(PLAYER_1));
			self:zoomto(GetFilterSizeX(PLAYER_1)+40,SCREEN_HEIGHT);
			self:fadeleft(1/32);
			self:faderight(1/32);
			if filter1 == 'OFF' then
				self:diffusealpha(0);
			elseif filter1 == '25%' then
				self:diffusealpha(0.25);
			elseif filter1 == '50%' then
				self:diffusealpha(0.5);
			elseif filter1 == '75%' then
				self:diffusealpha(0.75);
			else
				self:diffusealpha(1);
			end;
		end;
	};
	Def.Quad{
		Name="FilterP2";
		InitCommand=cmd(y,SCREEN_CENTER_Y;diffuse,Color("Black"););
		OnCommand=function(self)
			self:x(GetFilterPosX(PLAYER_2));
			self:zoomto(GetFilterSizeX(PLAYER_2)+40,SCREEN_HEIGHT);
			self:fadeleft(1/32);
			self:faderight(1/32);
			if filter2 == 'OFF' then
				self:diffusealpha(0);
			elseif filter2 == '25%' then
				self:diffusealpha(0.25);
			elseif filter2 == '50%' then
				self:diffusealpha(0.5);
			elseif filter2 == '75%' then
				self:diffusealpha(0.75);
			else
				self:diffusealpha(1);
			end;
		end;
	};
};

local function FilterUpdate(self)
	local fil1 = self:GetChild("FilterP1");
	local fil2 = self:GetChild("FilterP2");

	local song = GAMESTATE:GetCurrentSong();
	local start = song:GetFirstBeat();
	local last = song:GetLastBeat();
	local now = 0.0;
	now = GAMESTATE:GetSongBeat();
	if not GAMESTATE:IsDemonstration() then
		if (now >= start-8.0) and (now <= last) then
			if GAMESTATE:IsPlayerEnabled(PLAYER_1) then
				fil1:visible(1);
			else
				fil1:visible(0);
			end;
			if GAMESTATE:IsPlayerEnabled(PLAYER_2) then
				fil2:visible(1);
			else
				fil2:visible(0);
			end;
		else
			fil1:visible(0);
			fil2:visible(0);
		end;
	else
		fil1:visible(0);
		fil2:visible(0);
	end;
end;

t.InitCommand=cmd(SetUpdateFunction,FilterUpdate);

return t;
